/* ------------------------------------------------------------------------------
  File: chr6dm_HMC.c
  Author: CH Robotics
  Version: 1.0
  
  Description: Functions for interacting with HMC5843 magnetic sensor
------------------------------------------------------------------------------ */ 

#include "stm32f10x.h"
#include "CHR_ITG3200.h"
#include "CHR_i2c.h"

/*******************************************************************************
* Function Name  : initializeITG
* Input          : None
* Output         : uint8_t* status_flag
* Return         : 1 if success, 0 if fail
* Description    : Initializes the ITG3200 rate gyro
						 
*******************************************************************************/
int32_t initializeITG( uint8_t* status_flag )
{
	 uint8_t txBuf[4];
	 uint8_t returnval;

	 txBuf[0] = ITG_REG_SMPL;
	 txBuf[1] = 0x00;
	 txBuf[2] = 0x19;
	 txBuf[3] = 0x91;
	 
	 returnval = i2cBatchWrite( ITG_SLAVE_ADDRESS7, txBuf, 4 );
	 
	 txBuf[0] = ITG_REG_PWR;
	 txBuf[1] = 0x01;				// Set clock to X Gyro reference
	 
	 returnval = i2cBatchWrite( ITG_SLAVE_ADDRESS7, txBuf, 2 );
	 
	 /*
	 g_i2cTxBuf[0] = ITG_REG_SMPL;		// Start with the sample rate divider register
	 g_i2cTxBuf[1] = 0x00;					// Data for sample rate divider register (no divider)
	 g_i2cTxBuf[2] = 0x19;					// LPF config - 188 Hz cutoff
	 g_i2cTxBuf[3] = 0x91;					// 50uS pulse interrupt on raw data ready, low-asserted
	 
	 g_i2cCurrentSlaveAddress = ITG_SLAVE_ADDRESS7;
	 g_i2cDirection = I2C_TRANSMITTER;
	 g_i2cReadPrelude = 0;
	 g_i2cBytesToTransmit = 4;
	 i2cStart();

	 // Wait until finished transmitting
	 if( i2cWait() == 0 )
	 {
		  return 0;
	 }
	 
	 // Set clock source for gyro
	 g_i2cTxBuf[0] = ITG_REG_PWR;
	 g_i2cTxBuf[1] = 0x01;				// Set clock to X Gyro reference
	 
	 g_i2cCurrentSlaveAddress = ITG_SLAVE_ADDRESS7;
	 g_i2cTxPtr = 0;
	 g_i2cDirection = I2C_TRANSMITTER;
	 g_i2cBytesToTransmit = 2;
	 g_i2cReadPrelude = 0;
	 i2cStart();
	 
	 // Wait until finished transmitting
	 if( i2cWait() == 0 )
	 {
		  return 0;
	 }
	 */
	 return 1;
}

/*******************************************************************************
* Function Name  : getITGData
* Input          : None
* Output         : uint8_t* i2cBuf
* Return         : 1 if success, 0 if fail
* Description    : 
*******************************************************************************/
int32_t getITGData( )
{
	 int32_t returnval;
	 
	 i2cBatchRead( ITG_SLAVE_ADDRESS7, ITG_REG_GYRO_X_HIGH, g_i2cRxBuf, 6 );

	 return 1;
	 
	 /*
	 g_i2cCurrentSlaveAddress = ITG_SLAVE_ADDRESS7;
	 g_i2cDirection = I2C_TRANSMITTER;
	 g_i2cBytesToTransmit = 1;
	 g_i2cReadPrelude = 1;
	 
	 g_i2cTxBuf[0] = ITG_REG_GYRO_X_HIGH;
	 
	 returnval = i2cStart();
	 
	 if( returnval )
	 {
		  g_i2cCurrentSlaveAddress = ITG_SLAVE_ADDRESS7;
		  g_i2cDirection = I2C_RECEIVER;
		  g_i2cBytesToReceive = 6;
		  g_i2cReadPrelude = 0;
		  
		  returnval = i2cStart();
	 }
	 else
	 {
		  
	 }
	 */
	 
	 /*
	 // Send START condition
	 I2C_GenerateSTART(I2C1, ENABLE);

	 // Wait for START condition to transmit
	 if( !i2cWaitForEvent(I2C_EVENT_MASTER_MODE_SELECT) )
	 {
		  i2cReset();
//		  I2C_GenerateSTOP(I2C1, ENABLE);
		  return 0;
	 }
	 
	 // Send slave address
	 I2C_Send7bitAddress(I2C1, ITG_SLAVE_ADDRESS7, I2C_Direction_Transmitter);

	 // Wait for ACK
	 if( !i2cWaitForEvent(I2C_EVENT_MASTER_TRANSMITTER_MODE_SELECTED) )
	 {
		  i2cReset();
//		  I2C_GenerateSTOP(I2C1, ENABLE);
		  return 0;
	 }
	 
	 // Send address of x-axis gyro high byte
	 I2C_SendData(I2C1, ITG_REG_GYRO_X_HIGH);

	 // Wait for ACK
	 if( !i2cWaitForEvent(I2C_EVENT_MASTER_BYTE_TRANSMITTED) )
	 {
		  i2cReset();
//		  I2C_GenerateSTOP(I2C1, ENABLE);
		  return 0;
	 }
	 
	 // Start reading	 
	 returnval = i2cRead( ITG_SLAVE_ADDRESS7, i2cBuf, 6 );

	 if( !returnval )
	 {
		  i2cReset();
//		  I2C_GenerateSTOP(I2C1, ENABLE);
		  return 0;
	 }
	 else
	 {
		  return 1;
	 }
	 */
}
